/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm.common;

import ibm.nways.jdm.common.OID;
import ibm.nways.jdm.common.OrderedHashtable;
import ibm.nways.jdm.common.SingleInstanceFactory;
import java.io.Serializable;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;

public final class ModelInfo
implements Serializable {
    public boolean critical = false;
    public boolean timeoutDetected;
    private Dictionary fields;
    private boolean monitored;
    private transient OID storedSnmpRowID;
    private transient OID storedRowID;

    public ModelInfo() {
        this.fields = new Hashtable(10);
        this.monitored = false;
        this.timeoutDetected = false;
        this.storedSnmpRowID = null;
        this.storedRowID = null;
    }

    public ModelInfo(boolean bl) {
        this.fields = bl ? new OrderedHashtable(10) : new Hashtable(10);
        this.monitored = false;
        this.timeoutDetected = false;
    }

    public static void copyInfo(ModelInfo modelInfo, ModelInfo modelInfo2) {
        ModelInfo.copyInfo(modelInfo, modelInfo2, true);
    }

    public static void copyInfo(ModelInfo modelInfo, ModelInfo modelInfo2, boolean bl) {
        if (bl) {
            modelInfo.removeAll();
        }
        Enumeration enumeration = modelInfo2.getItemIds();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Serializable serializable = modelInfo2.get(string);
            modelInfo.add(string, serializable);
        }
        if (modelInfo2.isBeingMonitored()) {
            modelInfo.flagAsMonitored();
            if (modelInfo2.isCritical()) {
                modelInfo.flagAsCritical();
            } else {
                modelInfo.flagAsNotCritical();
            }
        } else {
            modelInfo.flagAsNotMonitored();
            modelInfo.flagAsNotCritical();
        }
        modelInfo.timeoutDetected = modelInfo2.timeoutDetected;
        modelInfo.storedRowID = modelInfo2.storedRowID;
        modelInfo.storedSnmpRowID = modelInfo2.storedSnmpRowID;
    }

    public static boolean isSubSet(ModelInfo modelInfo, ModelInfo modelInfo2) {
        Enumeration enumeration = modelInfo2.getItemIds();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Serializable serializable = modelInfo.get(string);
            if (serializable != null) continue;
            return false;
        }
        return true;
    }

    public synchronized Serializable get(String string) {
        return (Serializable)this.fields.get(string);
    }

    public synchronized void add(String string) {
        this.fields.put(string, SingleInstanceFactory.getInstance("ibm.nways.jdm.common.Null"));
    }

    public synchronized void add(String string, Serializable serializable) {
        this.fields.put(string, serializable);
    }

    public synchronized void remove(String string) {
        this.fields.remove(string);
    }

    public synchronized void removeAll() {
        if (this.fields instanceof Hashtable) {
            ((Hashtable)this.fields).clear();
            return;
        }
        ((OrderedHashtable)this.fields).clear();
    }

    public synchronized int size() {
        return this.fields.size();
    }

    public Enumeration getItemIds() {
        return this.fields.keys();
    }

    public String toString() {
        return "monitored = " + this.monitored + ", timeoutDetected = " + this.timeoutDetected + ", fields = " + this.fields.toString();
    }

    public boolean isBeingMonitored() {
        return this.monitored;
    }

    public void flagAsMonitored() {
        this.monitored = true;
    }

    public void flagAsNotMonitored() {
        this.monitored = false;
    }

    public OID getStoredSnmpRowID() {
        return this.storedSnmpRowID;
    }

    public OID getStoredRowID() {
        return this.storedRowID;
    }

    public void setStoredSnmpRowID(OID oID) {
        this.storedSnmpRowID = oID;
    }

    public void setStoredRowID(OID oID) {
        this.storedRowID = oID;
    }

    public void flagAsCritical() {
        this.critical = true;
    }

    public void flagAsNotCritical() {
        this.critical = false;
    }

    public boolean isCritical() {
        return this.critical;
    }
}

